<?php

/**
 *
 * Copyright © 2015 TemplateMonster. All rights reserved.
 * See COPYING.txt for license details.
 *
 */

namespace TemplateMonster\FilmSlider\Block\Adminhtml\SliderItem\Widget\Element\Layer;

use Magento\Framework\Data\Form\Element\AbstractElement;
use Magento\Framework\Data\Form\Element\Factory;
use Magento\Framework\Data\Form\Element\CollectionFactory;
use Magento\Framework\Escaper;

class Sortable extends AbstractElement
{
    /**
     * @param Factory $factoryElement
     * @param CollectionFactory $factoryCollection
     * @param Escaper $escaper
     * @param array $data
     */
    public function __construct(
    Factory $factoryElement,
    CollectionFactory $factoryCollection,
    Escaper $escaper,
    $data = []
) {
        parent::__construct($factoryElement, $factoryCollection, $escaper, $data);
        $this->setType('layersortable');
        $this->setExtType('textfield');
    }


    /**
     * Get the HTML
     *
     * @return mixed
     */
    public function getHtml()
    {
        $this->addClass('input-text admin__control-text');
        return parent::getHtml();
    }

    /**
     * Get the attributes
     *
     * @return string[]
     */
    public function getHtmlAttributes()
    {
        return [
        'type',
        'title',
        'class',
        'style',
        'onclick',
        'onchange',
        'onkeyup',
        'disabled',
        'readonly',
        'maxlength',
        'tabindex',
        'placeholder',
        'data-form-part',
        'data-role',
        'data-action'
    ];
    }
}
