/**
 * @module       RD Parallax
 * @author       Evgeniy Gusarov
 * @see          https://ua.linkedin.com/pub/evgeniy-gusarov/8a/a40/54a
 * @version      3.6.5
 */
(function(){!function($,document,window){var RDParallax,chromeVersion,hasClassList,isChrome,isChromeIOS,isChromeNew,isIE,isMobile,isSafariIOS,isWebkit,isWin8;return isMobile=/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent),isChrome=/Chrome/.test(navigator.userAgent),isWebkit=/Chrome/.test(navigator.userAgent)&&/Google Inc/.test(navigator.vendor)||/Safari/.test(navigator.userAgent)&&/Apple Computer/.test(navigator.vendor),isChromeIOS=isMobile&&/crios/i.test(navigator.userAgent),isSafariIOS=/iPhone|iPad|iPod/i.test(navigator.userAgent)&&!!navigator.userAgent.match(/Version\/[\d\.]+.*Safari/),isIE=navigator.appVersion.indexOf("MSIE")!==-1||navigator.appVersion.indexOf("Trident/")>-1,isWin8=/windows nt 6.2/.test(navigator.userAgent.toLowerCase())||/windows nt 6.3/.test(navigator.userAgent.toLowerCase()),hasClassList=null!=document.body.classList,chromeVersion=!!isChrome&&navigator.userAgent.replace(/^.*Chrome\/([\d\.]+).*$/i,"$1"),isChromeNew=chromeVersion>="55.0.2883.75",RDParallax=function(){function RDParallax(options){this.options=$.extend(!0,{},this.Defaults,options),this.scenes=[],this.initialize(),this.scrollY=window.scrollY||window.pageYOffset,this.lastScrollY=-1,this.lastDocHeight=0,this.inputFocus=!1,this.checkLayerHeight=!1}var Layer,Scene;return Layer=function(){function Layer(element,aliases,windowWidth,windowHeight,sceneOffset,sceneHeight,sceneOn){var ref,ref1;switch(this.amend=null!=(ref=null!=(ref1=isWebkit||isIE||isMobile)?ref1:isChromeNew)?ref:{0:{60:0}},this.element=element,this.aliases=aliases,this.type=element.getAttribute("data-type")||"html","html"===this.type&&(this.holder=this.createHolder()),this.direction="normal"===element.getAttribute("data-direction")||null==element.getAttribute("data-direction")?1:-1,this.fade="true"===element.getAttribute("data-fade"),this.blur="true"===element.getAttribute("data-blur"),this.boundTo=document.querySelector(element.getAttribute("data-bound-to")),"media"===this.type&&(this.url=element.getAttribute("data-url")),this.responsive=this.getResponsiveOptions(),!isIE&&!isMobile||isMobile||isWin8&&isIE?this.element.style.position="absolute":this.element.style.position="fixed",this.type){case"media":null!=this.url&&(this.element.style["background-image"]="url("+this.url+")");break;case"html":isIE&&isMobile&&(this.element.style["z-index"]=1)}this.refresh(windowWidth,windowHeight,sceneOffset,sceneHeight,sceneOn)}return Layer.prototype.refresh=function(windowWidth,windowHeight,sceneOffset,sceneHeight,sceneOn){var layer;switch(layer=this,layer.speed=layer.getOption("speed",windowWidth)||0,layer.offset=layer.getOption("offset",windowWidth)||0,isMobile||isWin8&&isIE||(sceneOn?layer.element.style.position="fixed":layer.element.style.position="absolute"),isIE&&"html"===layer.type&&(layer.element.style.position="absolute"),layer.type){case"media":if(!isIE)return layer.offsetHeight=layer.getMediaHeight(windowHeight,sceneHeight,layer.speed,layer.direction),layer.element.style.height=layer.offsetHeight+"px";break;case"html":if(layer.element.style.width=this.holder.offsetWidth+"px",layer.offsetHeight=layer.element.offsetHeight,layer.holder.style.height=layer.offsetHeight+"px",!(!isIE&&!isMobile||isMobile||isWin8&&isIE))return isIE?layer.element.style.position="static":sceneOn&&(layer.element.style.left=layer.getOffset(layer.holder).left+"px",layer.element.style.top=layer.getOffset(layer.holder).top-sceneOffset+"px"),layer.holder.style.position="static";break;case"custom":return layer.offsetHeight=layer.element.offsetHeight}},Layer.prototype.createHolder=function(){var holder,layer;return layer=this,holder=document.createElement("div"),hasClassList?holder.classList.add("rd-parallax-layer-holder"):holder.className="rd-parallax-layer-holder",layer.element.parentNode.insertBefore(holder,layer.element),holder.appendChild(layer.element),(!isIE&&!isMobile||isChromeIOS)&&(holder.style.position="relative"),holder},Layer.prototype.isHolderWrong=function(){var layer;return layer=this,"html"===layer.type&&layer.holder.offsetHeight!==layer.element.offsetHeight},Layer.prototype.getOption=function(key,windowWidth){var layer,point,targetPoint;layer=this;for(point in layer.responsive)point<=windowWidth&&(targetPoint=point);return layer.responsive[targetPoint][key]},Layer.prototype.getResponsiveOptions=function(){var alias,aliases,i,j,k,len,point,ref,resolutions,responsive,value;responsive={},resolutions=[],aliases=[],ref=this.aliases;for(i in ref)alias=ref[i],resolutions.push(i),aliases.push(alias);for(i=k=0,len=resolutions.length;k<len;i=++k)for(point=resolutions[i],responsive[point]={};(j=i)>=-1;)!responsive[point].speed&&(value=this.element.getAttribute("data"+aliases[j]+"speed"))&&(responsive[point].speed=this.getSpeed(value)),!responsive[point].offset&&(value=this.element.getAttribute("data"+aliases[j]+"offset"))&&(responsive[point].offset=parseInt(value)),!responsive[point].fade&&(value=this.element.getAttribute("data"+aliases[j]+"fade"))&&(responsive[point].fade="true"===value),i--;return responsive},Layer.prototype.fuse=function(sceneOffset,sceneHeight){var layer,layerDevider,offsetTop,opacity,pos,sceneDevider;layer=this,offsetTop=layer.getOffset(layer.element).top+layer.element.getBoundingClientRect().top,sceneDevider=sceneOffset+sceneHeight/2,layerDevider=offsetTop+layer.offsetHeight/2,pos=sceneHeight/6,sceneDevider+pos>layerDevider&&sceneDevider-pos<layerDevider?layer.element.style.opacity=1:(opacity=sceneDevider-pos<layerDevider?1+(sceneDevider+pos-layerDevider)/sceneHeight/3*10:1-(sceneDevider-pos-layerDevider)/sceneHeight/3*10,layer.element.style.opacity=opacity<0?0:opacity>1?1:opacity.toFixed(2))},Layer.prototype.move=function(scrollY,windowWidth,windowHeight,sceneOffset,sceneHeight,documentHeight,sceneOn,agentOffset,inputFocus){var dy,h,layer,pos,v;if(layer=this,!(isIE&&"media"===layer.type||isMobile||isWin8&&isIE)){if(!sceneOn)return isWebkit&&(layer.element.style["-webkit-transform"]="translate3d(0,0,0)"),void(layer.element.style.transform="translate3d(0,0,0)");v=!isMobile||"html"===layer.type&&inputFocus||isChromeIOS?layer.speed*layer.direction:layer.speed*layer.direction-1,h=layer.offsetHeight,null!=agentOffset?dy=(sceneOffset+windowHeight-(agentOffset+windowHeight))/(windowHeight-sceneHeight):"media"!==layer.type&&(sceneOffset<windowHeight||sceneOffset>documentHeight-windowHeight)?(dy=sceneOffset<windowHeight?sceneOffset/(windowHeight-sceneHeight):(sceneOffset+windowHeight-documentHeight)/(windowHeight-sceneHeight),isFinite(dy)||(dy=0)):dy=.5,pos=isChromeIOS||isIE?(sceneHeight-h)/2+(windowHeight-sceneHeight)*dy*v+layer.offset:isMobile?-(sceneOffset-scrollY)*v+(sceneHeight-h)/2+(windowHeight-sceneHeight)*dy*(v+1)+layer.offset:-(sceneOffset-scrollY)*v+(sceneHeight-h)/2+(windowHeight-sceneHeight)*dy*v+layer.offset,isMobile&&null!=agentOffset&&(layer.element.style.top=sceneOffset-agentOffset+"px"),isWebkit&&(this.element.style["-webkit-transform"]="translate3d(0,"+pos+"px,0)"),this.element.style.transform="translate3d(0,"+pos+"px,0)"}},Layer.prototype.getSpeed=function(value){return Math.min(Math.max(parseFloat(value),0),2)},Layer.prototype.getMediaHeight=function(windowHeight,sceneHeight,speed,direction){var directionModifier;return directionModifier=direction===-1?(sceneHeight+windowHeight)*speed:0,sceneHeight+directionModifier+(speed<=1?Math.abs(windowHeight-sceneHeight)*speed:windowHeight*speed)+2*this.amend},Layer.prototype.getOffset=function(element){var bound,left,top;return bound=element.getBoundingClientRect(),left=bound.left+(window.scrollX||window.pageXOffset),top=bound.top+(window.scrollY||window.pageYOffset),{top:top,left:left}},Layer}(),Scene=function(){function Scene(element,aliases,windowWidth,windowHeight){var ref,scene;scene=this,scene.amend=null!=(ref=null!=isWebkit?isWebkit:isChromeNew)?ref:{0:{60:0}},scene.element=element,scene.aliases=aliases,scene.on=!0,scene.agent=document.querySelector(element.getAttribute("data-agent")),scene.anchor=scene.findAnchor(),scene.canvas=scene.createCanvas(),scene.layers=scene.createLayers(windowWidth),scene.fitTo=scene.getFitElement(),scene.responsive=scene.getResponsiveOptions(),scene.refresh(windowWidth,windowHeight)}return Scene.prototype.getFitElement=function(){var fitTo,scene;return scene=this,null!=(fitTo=scene.element.getAttribute("data-fit-to"))?"parent"===fitTo?scene.element.parentNode:document.querySelector(fitTo):null},Scene.prototype.findAnchor=function(){var parent,scene;for(scene=this,parent=scene.element.parentNode;null!=parent&&parent!==document;){if(scene.isTransformed.call(parent))return parent;parent=parent.parentNode}return null},Scene.prototype.createCanvas=function(){var canvas,scene;for(scene=this,canvas=document.createElement("div"),hasClassList?canvas.classList.add("rd-parallax-inner"):canvas.className="rd-parallax-inner",scene.element.appendChild(canvas);scene.element.firstChild!==canvas;)canvas.appendChild(scene.element.firstChild);return scene.element.style.position="relative",scene.element.style.overflow="hidden",isIE||isMobile?(canvas.style.position="absolute",isWin8&&isIE||(canvas.style.clip="rect(0, auto, auto, 0)"),isIE?canvas.style.transform="translate3d(0,0,0)":canvas.style.transform="none"):canvas.style.position="fixed",canvas.style.left=scene.offsetLeft+"px",canvas.style.top=0,isWebkit&&(canvas.style["margin-top"]="-"+scene.amend+"px",canvas.style.padding=scene.amend+"px 0",scene.element.style["z-index"]=0),canvas},Scene.prototype.getOption=function(key,windowWidth){var point,targetPoint;for(point in this.responsive)point<=windowWidth&&(targetPoint=point);return this.responsive[targetPoint][key]},Scene.prototype.getResponsiveOptions=function(){var alias,aliases,i,j,k,len,point,ref,resolutions,responsive,value;responsive={},resolutions=[],aliases=[],ref=this.aliases;for(i in ref)alias=ref[i],resolutions.push(i),aliases.push(alias);for(i=k=0,len=resolutions.length;k<len;i=++k)for(point=resolutions[i],responsive[point]={};(j=i)>=-1;)responsive[point].on||null==(value=this.element.getAttribute("data"+aliases[j]+"on"))||(responsive[point].on="false"!==value),null==responsive[point].on&&0===j&&(responsive[point].on=!0),i--;return responsive},Scene.prototype.createLayers=function(windowWidth,windowHeight){var element,elements,i,k,layers,len,scene;for(scene=this,elements=$(scene.element).find(".rd-parallax-layer").get(),layers=[],i=k=0,len=elements.length;k<len;i=++k)element=elements[i],layers.push(new Layer(element,scene.aliases,windowWidth,windowHeight,scene.offsetTop,scene.offsetHeight,scene.on));return layers},Scene.prototype.move=function(scrollY){var pos,scene;return scene=this,pos=null!=scene.anchor?scene.positionTop:scene.offsetTop-scrollY,isWebkit&&(scene.canvas.style["-webkit-transform"]="translate3d(0,"+pos+"px,0)"),scene.canvas.style.transform="translate3d(0,"+pos+"px,0)"},Scene.prototype.refresh=function(windowWidth,windowHeight){var k,l,layer,len,len1,mediaLayers,ref,scene;for(scene=this,mediaLayers=[],scene.on=scene.getOption("on",windowWidth),scene.offsetTop=scene.getOffset(scene.element).top,scene.offsetLeft=scene.getOffset(scene.element).left,scene.width=scene.element.offsetWidth,scene.canvas.style.width=scene.width+"px",null!=scene.anchor&&(scene.positionTop=scene.element.offsetTop),null!=scene.agent?(scene.agentOffset=scene.getOffset(scene.agent).top,scene.agentHeight=scene.agent.offsetHeight):scene.agentOffset=scene.agentHeight=null,ref=scene.layers,k=0,len=ref.length;k<len;k++)layer=ref[k],"media"===layer.type?mediaLayers.push(layer):layer.refresh(windowWidth,windowHeight,scene.offsetTop,scene.offsetHeight,scene.on);for(scene.offsetHeight=scene.canvas.offsetHeight-2*scene.amend,scene.element.style.height=scene.offsetHeight+"px",l=0,len1=mediaLayers.length;l<len1;l++)layer=mediaLayers[l],layer.refresh(windowWidth,windowHeight,scene.offsetTop,scene.offsetHeight,scene.on)},Scene.prototype.update=function(scrollY,windowWidth,windowHeight,documentHeight,inputFocus){var k,layer,len,ref,results,scene,sceneHeight,sceneOffset;for(scene=this,sceneOffset=scene.offsetTop,sceneHeight=scene.offsetHeight,isIE||isMobile||scene.move(scrollY),ref=scene.layers,results=[],k=0,len=ref.length;k<len;k++)layer=ref[k],layer.move(scrollY,windowWidth,windowHeight,sceneOffset,sceneHeight,documentHeight,scene.on,scene.agentOffset,inputFocus),layer.fade=layer.getOption("fade",windowWidth)||!1,!layer.fade||isMobile||isIE?results.push(void 0):results.push(layer.fuse(sceneOffset,sceneHeight));return results},Scene.prototype.isTransformed=function(){var el,t,transformed,transforms;el=this,transforms={webkitTransform:"-webkit-transform",OTransform:"-o-transform",msTransform:"-ms-transform",MozTransform:"-moz-transform",transform:"transform"};for(t in transforms)transforms.hasOwnProperty(t)&&null!=el.style[t]&&(transformed=window.getComputedStyle(el).getPropertyValue(transforms[t]));return null!=transformed&&transformed.length>0&&"none"!==transformed},Scene.prototype.getOffset=function(element){var bound,left,top;return bound=element.getBoundingClientRect(),left=bound.left+(window.scrollX||window.pageYOffset),top=bound.top+(window.scrollY||window.pageYOffset),{top:top,left:left}},Scene}(),RDParallax.prototype.Defaults={selector:".rd-parallax",screenAliases:{0:"-",480:"-xs-",768:"-sm-",992:"-md-",1200:"-lg-",1920:"-xl-",2560:"-xxl-"}},RDParallax.prototype.initialize=function(){var ctx,element,elements,i,k,len,windowHeight,windowWidth;for(ctx=this,elements=document.querySelectorAll(ctx.options.selector),windowWidth=window.innerWidth,windowHeight=window.innerHeight,i=k=0,len=elements.length;k<len;i=++k)element=elements[i],ctx.scenes.push(new Scene(element,ctx.options.screenAliases,windowWidth,windowHeight));$(window).on("resize",$.proxy(ctx.resize,ctx)),isSafariIOS&&$("input").on("focusin focus",function(e){return e.preventDefault(),ctx.activeOffset=$(this).offset().top,window.scrollTo(window.scrollX||window.pageXOffset,ctx.activeOffset-this.offsetHeight-100)}),$(window).trigger("resize"),ctx.update(),ctx.checkResize()},RDParallax.prototype.resize=function(forceResize){var ctx,currentWindowWidth,k,len,ref,scene;if(ctx=this,(currentWindowWidth=window.innerWidth)!==ctx.windowWidth||!isMobile||forceResize){for(ctx.windowWidth=currentWindowWidth,ctx.windowHeight=window.innerHeight,ctx.documentHeight=document.body.offsetHeight,ref=ctx.scenes,k=0,len=ref.length;k<len;k++)scene=ref[k],scene.refresh(ctx.windowWidth,ctx.windowHeight);return ctx.update(!0)}},RDParallax.prototype.update=function(forceUpdate){var activeElement,ctx,deltaHeight,deltaScroll,documentHeight,k,len,ref,scene,scrollY,windowHeight,windowWidth;if(ctx=this,forceUpdate||requestAnimationFrame(function(){ctx.update()}),scrollY=window.scrollY||window.pageYOffset,isSafariIOS&&null!=(activeElement=document.activeElement)&&(activeElement.tagName.match(/(input)|(select)|(textarea)/i)?(ctx.activeElement=activeElement,ctx.inputFocus=!0):(ctx.activeElement=null,ctx.inputFocus=!1,forceUpdate=!0)),isMobile&&isChrome&&(deltaHeight=window.innerHeight-ctx.windowHeight,ctx.deltaHeight=deltaHeight,scrollY-=ctx.deltaHeight),(scrollY!==ctx.lastScrollY||forceUpdate)&&!ctx.isActing){for(ctx.isActing=!0,windowWidth=ctx.windowWidth,windowHeight=ctx.windowHeight,documentHeight=ctx.documentHeight,deltaScroll=scrollY-ctx.lastScrollY,isSafariIOS&&null!=ctx.activeElement&&(ctx.activeElement.value=ctx.activeElement.value+" ",ctx.activeElement.value=ctx.activeElement.value.trim()),ref=ctx.scenes,k=0,len=ref.length;k<len;k++)scene=ref[k],(ctx.inputFocus||forceUpdate||scrollY+windowHeight>=(scene.agentOffset||scene.offsetTop)+deltaScroll&&scrollY<=(scene.agentOffset||scene.offsetTop)+(scene.agentHeight||scene.offsetHeight)+deltaScroll)&&scene.update(scrollY,windowWidth,windowHeight,documentHeight,ctx.inputFocus);return ctx.lastScrollY=scrollY,ctx.isActing=!1}},RDParallax.prototype.checkResize=function(){var ctx;ctx=this,setInterval(function(){var docHeight,k,l,layer,len,len1,ref,ref1,scene;for(docHeight=document.body.offsetHeight,ref=ctx.scenes,k=0,len=ref.length;k<len;k++){for(scene=ref[k],ref1=scene.layers,l=0,len1=ref1.length;l<len1;l++)if(layer=ref1[l],layer.isHolderWrong()){ctx.checkLayerHeight=!0;break}if(ctx.checkLayerHeight)break}if(ctx.checkLayerHeight||docHeight!==ctx.lastDocHeight)return ctx.resize(!0),ctx.lastDocHeight=docHeight,ctx.checkLayerHeight=!1},500)},RDParallax}(),$.RDParallax=function(options){var $doc;if($doc=$(document),!$doc.data("RDParallax"))return $doc.data("RDParallax",new RDParallax(options))},window.RDParallax=RDParallax}(window.jQuery,document,window),"undefined"!=typeof module&&null!==module?module.exports=window.RDParallax:"function"==typeof define&&define.amd&&define(["jquery"],function(){"use strict";return window.RDParallax})}).call(this);